System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, _decorator, Component, Node, find, Prefab, resources, instantiate, _dec, _class, _temp, _crd, ccclass, property, addProp;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      find = _cc.find;
      Prefab = _cc.Prefab;
      resources = _cc.resources;
      instantiate = _cc.instantiate;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "f65b26gsEJBsrpfQX7Wj7dZ", "addProp", undefined);

      ({
        ccclass,
        property
      } = _decorator);

      _export("addProp", addProp = (_dec = ccclass('addProp'), _dec(_class = (_temp = class addProp extends Component {
        constructor() {
          super(...arguments);

          _defineProperty(this, "propManager", null);
        }

        //道具管理节点
        onLoad() {
          this.propManager = find('Canvas/terrain').getChildByName('propManager');
          this.node.on(Node.EventType.TOUCH_START, this.touchStart, this); //监听点击开始事件

          this.node.on(Node.EventType.TOUCH_MOVE, this.touchMove, this); //监听点击移动事件

          this.node.on(Node.EventType.TOUCH_END, this.touchEnd, this); //监听点击结束事件
        }

        onDisable() {
          this.node.off(Node.EventType.TOUCH_START, this.touchStart, this); //取消监听点击开始事件

          this.node.off(Node.EventType.TOUCH_MOVE, this.touchMove, this); //取消监听点击移动事件

          this.node.off(Node.EventType.TOUCH_END, this.touchEnd, this); //取消监听点击结束事件
        }
        /**
         * 开始点击
         */


        touchStart(touch) {}
        /**
         * 点击移动
         */


        touchMove(touch) {
          var nowpos = this.node.getPosition(); //获取当前位置

          var dalta = touch.getUIDelta(); //获取两次移动之间的差值

          this.node.setPosition(nowpos.x + dalta.x, nowpos.y + dalta.y, nowpos.z); //设置到新位置
        }
        /**
         * 点击结束
         */


        touchEnd(touch) {
          var nowPos = this.node.getPosition();
          var worldPos = this.node.getWorldPosition(); //获取节点世界位置

          if (Math.abs(0 - nowPos.x) > 75 || Math.abs(0 - nowPos.y) > 75) {
            //如果移动后的距离
            resources.load("prefab/" + this.node.name, Prefab, (err, prefab) => {
              //获取预制体资源
              var newNode = instantiate(prefab); //实例化预制体资源

              this.propManager.addChild(newNode); //添加子节点

              newNode.setWorldPosition(worldPos);
              var index = newNode.getSiblingIndex(); //获取当前节点在父节点的 children 数组中的位置。

              var frontIndex = newNode.parent.children[index - 1]; //获取当前节点在父节点的 children 数组中前面位置的节点。

              if (frontIndex != null) {
                //如果前面一个节点存在
                var frontPos = frontIndex.getPosition();

                if (newNode.position.x - frontIndex.position.x < 100 && newNode.position.y - frontIndex.position.y < 20 && frontIndex.name == newNode.name) {
                  newNode.setPosition(frontIndex.position.x + 100, frontIndex.position.y, 0);
                }
              }
            });
          }

          this.node.setPosition(0, 0, 0);
        }

      }, _temp)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=addProp.js.map